function HSLdata = rgb2hsl(RGBdata)

    MatSize = size(RGBdata);
    HSLdata = zeros(MatSize);

	rMat = RGBdata(:,:,1);
	gMat = RGBdata(:,:,2);
	bMat = RGBdata(:,:,3);
    
    for i = 1:MatSize(1)
        for j = 1:MatSize(2)
    
            r = rMat(i,j)/255.0;
            g = gMat(i,j)/255.0;
            b = bMat(i,j)/255.0;
            
            maxColor = max(r, max(g, b));
            minColor = min(r, min(g, b));

            if ((r == g) && (g == b))
                h = 0.0; 
                s = 0.0;
                l = r; 
            else 
                d = maxColor - minColor;
                l = (minColor + maxColor) / 2;

                if (l < 0.5) 
                    s = d / (maxColor + minColor);
                else
                    s = d / (2.0 - maxColor - minColor);
                end

                if (r == maxColor) 
                    h = (g - b) / (maxColor - minColor);
                elseif(g == maxColor) 
                    h = 2.0 + (b - r) / (maxColor - minColor);
                else
                    h = 4.0 + (r - g) / (maxColor - minColor);
                end

                h = h/6; 

                if (h < 0) 
                    h = h + 1;
                end
            end
            HSLdata(i,j,1) = floor(h * 360.0);
            HSLdata(i,j,2) = s;
            HSLdata(i,j,3) = l;
        end
    end

end